#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=212773 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188734, 'Database Backup [database_backup_2025-01-25-00-04-02-v3-1-6.zip]', '2025-01-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (188999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189437, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-25 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189438, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-25 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189541, 'Database Backup [database_backup_2025-01-26-00-00-02-v3-1-6.zip]', '2025-01-26 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (189999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190235, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-26 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190335, 'Database Backup [database_backup_2025-01-27-00-02-02-v3-1-6.zip]', '2025-01-27 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (190999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-27 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-27 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-27 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191128, 'Database Backup [database_backup_2025-01-28-00-02-03-v3-1-6.zip]', '2025-01-28 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 07:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 07:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 07:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191822, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-28 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191823, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-28 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-28 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-28 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-28 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191923, 'Database Backup [database_backup_2025-01-29-00-02-02-v3-1-6.zip]', '2025-01-29 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (191999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 13:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 13:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 13:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-29 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-29 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (192503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-29 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `dat