#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=207095 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (182999, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-17 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-17 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-17 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-17 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183099, 'Database Backup [database_backup_2025-01-18-00-01-02-v3-1-6.zip]', '2025-01-18 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-18 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-18 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-18 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183886, 'Database Backup [database_backup_2025-01-19-00-02-02-v3-1-6.zip]', '2025-01-19 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (183999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184580, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-19 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184581, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-19 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-19 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-19 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-19 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184684, 'Database Backup [database_backup_2025-01-20-00-02-02-v3-1-6.zip]', '2025-01-20 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (184999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185375, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-20 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-20 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-20 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-20 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185481, 'Database Backup [database_backup_2025-01-21-00-00-02-v3-1-6.zip]', '2025-01-21 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 02:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 02:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 02:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 03:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 03:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 03:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 03:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 03:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 03:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (185999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-21 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-21 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-21 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186310, 'Database Backup [database_backup_2025-01-22-00-05-02-v3-1-6.zip]', '2025-01-22 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-22 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-22 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (186873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-22 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `descrip