#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=282866 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (258999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259020, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:94e1:ea74:f84a:64cd]', '2025-04-21 12:53:09', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259021, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:94e1:ea74:f84a:64cd]', '2025-04-21 12:53:37', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 20:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 20:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 20:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 20:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 20:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 20:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 21:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 21:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 21:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-21 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-21 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-21 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259409, 'Database Backup [database_backup_2025-04-22-00-04-03-v3-1-6.zip]', '2025-04-22 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 08:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 08:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 08:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 09:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 09:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 09:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 12:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 12:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 12:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 12:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 12:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 12:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 13:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 13:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 13:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 13:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 13:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 13:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 15:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 15:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 15:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 15:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 15:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 15:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 15:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 15:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 15:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (259999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260145, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-22 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260146, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-22 21:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 21:05:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 21:05:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 21:05:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 23:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-22 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-22 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-22 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260249, 'Database Backup [database_backup_2025-04-23-00-01-03-v3-1-6.zip]', '2025-04-23 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 05:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 05:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 05:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 06:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 06:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 06:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 09:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 09:34:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 09:34:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 10:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 11:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 11:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 11:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 11:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 11:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 11:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 11:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 11:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 11:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 11:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 11:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 11:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 11:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 11:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 11:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 14:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 14:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 14:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 15:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:29:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 17:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 17:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 17:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 19:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 19:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 19:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 19:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260946, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-04-23 19:53:39', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260983, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-23 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (260999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 22:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 22:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 22:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 22:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 22:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 22:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261095, 'Database Backup [database_backup_2025-04-24-00-00-04-v3-1-6.zip]', '2025-04-24 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 08:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 08:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 08:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 13:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 19:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 19:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 19:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-24 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-24 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-24 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261921, 'Database Backup [database_backup_2025-04-25-00-04-03-v3-1-6.zip]', '2025-04-25 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (261999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 20:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 20:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 20:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262636, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-25 21:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262637, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-25 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-25 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-25 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-25 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262743, 'Database Backup [database_backup_2025-04-26-00-03-03-v3-1-6.zip]', '2025-04-26 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (262999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-26 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-26 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (263158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-26 12:34:02', '[CRON]');
INSERT INT