#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=359455 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 05:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 05:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 05:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 15:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 15:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 15:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346398, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:1474:5d98:cd5a:5f4a]', '2025-08-06 16:22:21', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346405, 'Invoice Status Updated [Invoice Number: INV-181/08/2025, From: Draft To: Unpaid]', '2025-08-06 16:36:58', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346541, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-06 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346542, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-08-06 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346543, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-08-06 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 22:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 22:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 22:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 23:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 23:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 23:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346640, 'Database Backup [database_backup_2025-08-07-00-00-04-v3-3-1.zip]', '2025-08-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 08:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 09:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 09:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 09:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (346999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347043, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:ca86:8cbd:1c2b:df8b]', '2025-08-07 12:51:39', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 13:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347050, 'Invoice Status Updated [Invoice Number: INV-179/07/2025, From: Overdue To: Unpaid]', '2025-08-07 13:03:05', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 13:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347099, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:1474:5d98:cd5a:5f4a]', '2025-08-07 14:38:22', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 18:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 18:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 18:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 19:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 19:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 19:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 19:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 19:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 19:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347298, 'Email Sent To [Email: naresh.sookhan@gmail.com, Template: Invoice Overdue Notice]', '2025-08-07 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347299, 'Invoice Status Updated [Invoice Number: INV-181/08/2025, From: Unpaid To: Overdue]', '2025-08-07 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 22:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 22:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 22:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-07 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-07 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-07 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347396, 'Database Backup [database_backup_2025-08-08-00-00-06-v3-3-1.zip]', '2025-08-08 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 12:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 12:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 12:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 12:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 16:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 16:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 16:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 18:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 18:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 18:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347967, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:1474:5d98:cd5a:5f4a]', '2025-08-08 18:31:58', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (347999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348046, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-08 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348047, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-08 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-08 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-08 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-08 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348144, 'Database Backup [database_backup_2025-08-09-00-03-02-v3-3-1.zip]', '2025-08-09 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 09:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 09:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 09:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 14:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 14:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 14:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348790, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:1474:5d98:cd5a:5f4a]', '2025-08-09 20:48:12', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348797, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-09 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348798, 'Invoice Status Updated [Invoice Number: INV-179/07/2025, From: Unpaid To: Overdue]', '2025-08-09 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348799, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-08-09 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348800, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-08-09 21:02:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 21:02:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 21:02:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 21:02:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348834, 'Invoice Status Updated [Invoice Number: INV-183/02/2025, From: Draft To: Unpaid]', '2025-08-09 22:02:40', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348835, 'Invoice Status Updated [Invoice Number: INV-183/02/2025, From: Unpaid To: Partially Paid]', '2025-08-09 22:03:05', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348836, 'Payment Recorded [ID:132, Invoice Number: INV-183/02/2025, Total: $1,750.00]', '2025-08-09 22:03:05', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348837, 'Email Sent To [Email: keripatrick@me.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-08-09 22:03:11', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348838, 'Email Sent To [Email: dallas.f@saylessdigital.io, Template: Invoice Payment Recorded (Sent to Staff)]', '2025-08-09 22:03:13', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348839, 'Invoice Status Updated [Invoice Number: INV-183/02/2025, From: Partially Paid To: Unpaid]', '2025-08-09 22:03:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348840, 'Payment Deleted [ID:132, Invoice Number: ]', '2025-08-09 22:03:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348841, 'Invoice Status Updated [Invoice Number: INV-182/08/2025, From: Unpaid To: Partially Paid]', '2025-08-09 22:05:10', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348842, 'Payment Recorded [ID:133, Invoice Number: INV-182/08/2025, Total: $1,750.00]', '2025-08-09 22:05:10', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348843, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-08-09 22:05:16', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348844, 'Email Sent To [Email: dallas.f@saylessdigital.io, Template: Invoice Payment Recorded (Sent to Staff)]', '2025-08-09 22:05:19', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-09 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-09 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-09 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348908, 'Database Backup [database_backup_2025-08-10-00-03-02-v3-3-1.zip]', '2025-08-10 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (348999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349131, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:1474:5d98:cd5a:5f4a]', '2025-08-10 07:17:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 10:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 12:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 12:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 12:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 12:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 15:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349561, 'Email Sent To [Email: naresh.sookhan@gmail.com, Template: Invoice Overdue Notice]', '2025-08-10 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 21:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 21:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 21:05:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-10 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-10 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-10 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349655, 'Database Backup [database_backup_2025-08-11-00-00-04-v3-3-1.zip]', '2025-08-11 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 10:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 10:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 10:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (349999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350304, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-11 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350305, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-11 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350306, 'Invoice Status Updated [Invoice Number: INV-184/08/2025, From: Unpaid To: Overdue]', '2025-08-11 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350307, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-08-11 21:02:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350308, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-08-11 21:02:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:02:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:02:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:02:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-11 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-11 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-11 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350405, 'Database Backup [database_backup_2025-08-12-00-00-03-v3-3-1.zip]', '2025-08-12 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (350451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-12 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALU