#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=261921 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (236999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 18:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 18:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 18:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 18:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 20:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 20:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 20:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 21:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 21:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 21:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 21:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237145, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:16ba:a258:a264:edd8]', '2025-03-25 22:18:02', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 23:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-25 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-25 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-25 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237203, 'Database Backup [database_backup_2025-03-26-00-02-04-v3-1-6.zip]', '2025-03-26 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 07:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 07:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 07:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 12:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 16:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 16:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 16:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 17:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237912, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-26 21:01:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237913, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-26 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 21:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 21:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 22:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (237999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-26 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-26 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-26 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238025, 'Database Backup [database_backup_2025-03-27-00-04-03-v3-1-6.zip]', '2025-03-27 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238731, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238837, 'Database Backup [database_backup_2025-03-28-00-00-06-v3-1-6.zip]', '2025-03-28 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239618, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:16ba:a258:a264:edd8]', '2025-03-28 22:51:19', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239658, 'Database Backup [database_backup_2025-03-29-00-00-04-v3-1-6.zip]', '2025-03-29 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240400, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-29 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240401, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-29 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240522, 'Database Backup [database_backup_2025-03-30-00-04-02-v3-1-6.zip]', '2025-03-30 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:14:02', '[CRON]')